<?php
require_once __DIR__.'/utils.php';
require_once __DIR__.'/db.php';

if ($_SERVER['REQUEST_METHOD']==='OPTIONS') exit;
require_api_key();

$key = trim($_GET['license_key'] ?? '');
if ($key==='') json_err(400,'MISSING_FIELDS');

try {
  $pdo = pdo_conn();
  $st = $pdo->prepare("SELECT Wallet_Balance FROM license_keys WHERE LicenseKey=?");
  $st->execute([$key]);
  $row = $st->fetch();
  if (!$row) json_err(404,'KEY_NOT_FOUND');
  json_ok(['wallet'=>(int)$row['Wallet_Balance']]);
} catch (Throwable $e) {
  json_err(500,'SERVER_ERROR');
}
