<?php
require_once __DIR__.'/utils.php';
require_once __DIR__.'/db.php';

if ($_SERVER['REQUEST_METHOD']==='OPTIONS') exit;
require_api_key();

$body = json_decode(file_get_contents('php://input'), true) ?: [];
$key  = trim($body['license_key'] ?? '');
$name = trim($body['func_name'] ?? '');
$desc = trim($body['func_desc'] ?? '');
$cost = 30;

if ($key==='' || $name==='') json_err(400,'MISSING_FIELDS');

try {
  $pdo = pdo_conn();
  $pdo->beginTransaction();

  // Khóa bản ghi
  $st = $pdo->prepare("SELECT Wallet_Balance, Time_Expired FROM license_keys WHERE LicenseKey=? FOR UPDATE");
  $st->execute([$key]);
  $row = $st->fetch();
  if (!$row) { $pdo->rollBack(); json_err(404,'KEY_NOT_FOUND'); }

  if (strtotime($row['Time_Expired']) <= time()) { $pdo->rollBack(); json_err(403,'EXPIRED'); }

  $wallet = (int)$row['Wallet_Balance'];
  if ($wallet < $cost) { $pdo->rollBack(); json_err(402,'NOT_ENOUGH_POINTS'); }

  // Trừ ví
  $new_wallet = $wallet - $cost;
  $up = $pdo->prepare("UPDATE license_keys SET Wallet_Balance=? WHERE LicenseKey=?");
  $up->execute([$new_wallet, $key]);

  // (Khuyến nghị) Lưu log order (tạo bảng ở dưới – nếu chưa có thì có thể bỏ qua phần này)
  try {
    $pdo->exec("CREATE TABLE IF NOT EXISTS feature_orders (
      id INT AUTO_INCREMENT PRIMARY KEY,
      license_key VARCHAR(64) NOT NULL,
      func_name VARCHAR(255) NOT NULL,
      func_desc TEXT NULL,
      cost INT NOT NULL,
      created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
      INDEX(license_key)
    )");
    $ins = $pdo->prepare("INSERT INTO feature_orders (license_key, func_name, func_desc, cost) VALUES (?,?,?,?)");
    $ins->execute([$key, $name, $desc, $cost]);
  } catch (Throwable $e) {
    // Không chặn giao dịch nếu tạo bảng/log thất bại
  }

  $pdo->commit();
  json_ok(['wallet'=>$new_wallet]);
} catch (Throwable $e) {
  if (isset($pdo) && $pdo->inTransaction()) $pdo->rollBack();
  json_err(500,'SERVER_ERROR');
}
