<?php
require_once __DIR__.'/utils.php';
require_once __DIR__.'/db.php';

if ($_SERVER['REQUEST_METHOD']==='OPTIONS') exit;
require_api_key();

$body = json_decode(file_get_contents('php://input'), true) ?: [];
$key  = trim($body['license_key'] ?? '');
$fid  = (int)($body['func_id'] ?? 0);
$cost = 20; // theo GUI

if ($key==='' || $fid<=0) json_err(400,'MISSING_FIELDS');

try {
  $pdo = pdo_conn();
  $pdo->beginTransaction();

  // Khóa bản ghi
  $st = $pdo->prepare("SELECT Functions, Wallet_Balance FROM license_keys WHERE LicenseKey=? FOR UPDATE");
  $st->execute([$key]);
  $row = $st->fetch();
  if (!$row) { $pdo->rollBack(); json_err(404,'KEY_NOT_FOUND'); }

  $functions = trim((string)$row['Functions']);
  $wallet    = (int)$row['Wallet_Balance'];

  if ($functions !== '' && strcasecmp($functions,'all')===0) {
    $pdo->rollBack(); json_err(409,'ALREADY_ALL');
  }

  if ($wallet < $cost) {
    $pdo->rollBack(); json_err(402,'NOT_ENOUGH_POINTS'); // 402 Payment Required
  }

  // Tạo danh sách mới (CSV)
  $list = [];
  if ($functions !== '') {
    foreach (explode(',', $functions) as $x) {
      $x = trim($x);
      if ($x !== '') $list[$x] = true;
    }
  }
  $list[(string)$fid] = true; // thêm nếu chưa có

  $new_functions = implode(',', array_keys($list));
  $new_wallet    = $wallet - $cost;

  $up = $pdo->prepare("UPDATE license_keys SET Functions=?, Wallet_Balance=? WHERE LicenseKey=?");
  $up->execute([$new_functions, $new_wallet, $key]);

  $pdo->commit();
  json_ok(['functions'=>$new_functions, 'wallet'=>$new_wallet]);
} catch (Throwable $e) {
  if (isset($pdo) && $pdo->inTransaction()) $pdo->rollBack();
  json_err(500,'SERVER_ERROR');
}
