<?php
require_once __DIR__.'/utils.php';
require_once __DIR__.'/db.php';

if ($_SERVER['REQUEST_METHOD']==='OPTIONS') exit;
require_api_key();

$body   = json_decode(file_get_contents('php://input'), true) ?: [];
$key    = trim($body['license_key'] ?? '');
$device = trim($body['device_id'] ?? '');

if ($key==='' || $device==='') json_err(400,'MISSING_FIELDS');

try {
  $pdo = pdo_conn();
  // Lấy bản ghi theo LicenseKey
  $st = $pdo->prepare("SELECT Name, Time_Expired, Mac_Address, Functions, Wallet_Balance
                       FROM license_keys WHERE LicenseKey = ?");
  $st->execute([$key]);
  $row = $st->fetch();
  if (!$row) json_err(404, 'KEY_NOT_FOUND');

  // Hết hạn?
  if (strtotime($row['Time_Expired']) <= time()) json_err(403, 'EXPIRED');

  // Bind/kiểm tra máy
  $mac = $row['Mac_Address'];
  if ($mac === null || $mac === '') {
    $up = $pdo->prepare("UPDATE license_keys SET Mac_Address=? WHERE LicenseKey=?");
    $up->execute([$device, $key]);
    $mac = $device;
  } elseif ($mac !== 'full' && $mac !== $device) {
    json_err(403, 'DEVICE_MISMATCH');
  }

  json_ok([
    'name'       => $row['Name'],
    'expired_at' => $row['Time_Expired'],
    'mac'        => $mac,
    'functions'  => $row['Functions'] ?? '',
    'wallet'     => (int)$row['Wallet_Balance'],
  ]);
} catch (Throwable $e) {
  json_err(500,'SERVER_ERROR');
}
